﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample4
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern bool DeleteObject(IntPtr hObject);

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateSolidBrush(int crColor);

        [DllImport("user32.dll")]
        public static extern bool FillRect(IntPtr hDC, [In] ref Rectangle lpRect, IntPtr hBrush);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonDraw_Click(object sender, EventArgs e)
        {
            IntPtr hDC = GetDC(this.Handle);
            IntPtr hBrush = CreateSolidBrush(ColorTranslator.ToWin32(Color.Green));
            Rectangle lpRect = new Rectangle(100, 100, 250, 200);
            FillRect(hDC, ref lpRect, hBrush);
            DeleteObject(hBrush);
            DeleteObject(hDC);
        }
    }
}